function validateTIN(tin) 
{
   var area = parseInt(tin.substring(0, 3));

   return (
       tin.length === 9 &&
       tin.match(/^[1-9][0-9]{2}[1-9][0-9]{1}[1-9][0-9]{3}/) &&
       area !== 666 &&
       area < 900 &&
       tin !== '078051120' &&
       tin !== '219099999'
   );
}

function tinOnChange() 
{
    var fieldName = "ppms_provideridentifier";

    Xrm.Page.ui.clearFormNotification("tinValidation");
    Xrm.Page.getControl(fieldName).clearNotification("tinFieldValidation");

    var tin = Xrm.Page.getAttribute(fieldName).getValue();

    if (tin != null) {
        var isValid = validateTIN(tin);

        if (isValid == false) 
        {
            Xrm.Page.getAttribute(fieldName).setValue(null);
            Xrm.Page.ui.setFormNotification("Tax ID Number is not valid! ", "ERROR", "tinValidation");
            Xrm.Page.getControl(fieldName).setNotification("Tax ID Number is not valid", "tinFieldValidation");
        }
    }
}

function validateNPI(npi) 
{
   return (
       npi.length === 10
   );
}

function providerFormOnChange()
{
    identifierOnChange("ppms_provideridentifiertype");
}

function providerIdentifierFormOnChange()
{
    identifierOnChange("ppms_identifiertype");
}

function identifierOnChange(idFieldName) 
{
    // Set default values
    var fieldName = "ppms_provideridentifier";
    var errorMsg = "NPI is not valid";
    var idType = "NPI";

    Xrm.Page.ui.clearFormNotification("idValidation");
    Xrm.Page.getControl(fieldName).clearNotification("idFieldValidation");

    var id = Xrm.Page.getAttribute(fieldName).getValue();
    var objType = Xrm.Page.getAttribute(idFieldName);
    if (objType != null)
        idType = objType.getText();

    if (id != null) {
        var isValid = false;

        if (idType == "Tax ID Number")
        {
            // TIN validation
            isValid = validateTIN(id);
            errorMsg = "TIN is not valid";
        }
        else
        {
            // NPI validation
            isValid = validateNPI(id);
        }

        if (isValid == false) 
        {
            Xrm.Page.getAttribute(fieldName).setValue(null);
            Xrm.Page.ui.setFormNotification(errorMsg, "ERROR", "idValidation");
            Xrm.Page.getControl(fieldName).setNotification(errorMsg, "idFieldValidation");
        }
    }
}
